<?php require_once('partials/head.php');?>
<?php require_once('partials/nav.php');?>
<div class="check-rotate-support"></div>
<div class="nk-content">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head">
                    <div class="nk-block-between g-3">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">Lịch Sử Nạp Ngân Hàng</h3>
                            <div class="nk-block-des text-soft">
                                <p>Bạn có tổng cộng <?=$totals->Bank()?> hoá đơn nạp ngân hàng.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="nk-block">
                    <div class="card card-bordered card-stretch">
                        <div class="card-inner table-responsive">
                            <table class="table table-tranx" id="bankTable">
                                <thead>
                                    <tr>
                                        <th scope="col">Mã Giao Dịch</th>
                                        <th scope="col">Tài Khoản</th>
                                        <th scope="col">Loại</th>
                                        <th scope="col">Số Tiền</th>
                                        <th scope="col">Nội Dung</th>
                                        <th scope="col">Thời Gian</th>
                                        <th scope="col">Trạng Thái</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', () => {
    if ($.fn.DataTable.isDataTable('#bankTable')) {
        $('#bankTable').DataTable().destroy();
    }

    const dataTable = $('#bankTable').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        ajax: {
            url: '/api/admin/handler?action=bankList',
            type: 'GET',
            data: function(d) {
                return {
                    page: Math.floor(d.start / d.length) + 1,
                    limit: d.length,
                    search: d.search.value
                };
            },
            dataFilter: function(data) {
                let json = JSON.parse(data);
                json.recordsTotal = json.data.pagination.total_banks;
                json.recordsFiltered = json.data.pagination.total_banks;
                json.data = json.data.banks;
                return JSON.stringify(json);
            }
        },
        dom: '<"row justify-between g-2"<"col-7 col-sm-4 text-left"f><"col-5 col-sm-8 text-right"<"datatable-filter"<"d-flex justify-content-end g-2"l>>>><"datatable-wrap my-3"t><"row align-items-center"<"col-7 col-sm-12 col-md-9"p><"col-5 col-sm-12 col-md-3 text-end text-md-right"i>>',
        columns: [
            { 
                data: 'magiaodich',
                className: 'nk-tb-col',
                render: function(data) {
                    return `#${data}`;
                }
            },
            { 
                data: null,
                className: 'nk-tb-col',
                render: function(data) {
                    const Username = window.THANHDIEU ? window.THANHDIEU(data.username) : data.username;
                    return `
                        <div class="user-card">
                            <div class="user-avatar" style="background-color:${data.avatar}">
                                <span>${Username.charAt(0).toUpperCase()}</span>
                            </div>
                            <div class="user-info">
                                <span class="tb-lead text-white">${Username}</span>
                                <span class="sub-text fs-12px">@${Username}</span>
                            </div>
                        </div>`;
                }
            },
            { 
                data: 'loai',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="badge rounded-pill bg-gray">${data}</span>`;
                }
            },
            { 
                data: 'sotien',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="badge rounded-pill bg-primary">${data}đ</span>`;
                }
            },
            { 
                data: 'noidung',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="badge rounded-pill bg-secondary">${data.length > 40 ? data.substring(0, 40) + '...' : data}</span>`;
                }
            },
            { 
                data: 'thoigian',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="badge rounded-pill bg-info">${data}</span>`;
                }
            },
            { 
                data: 'trangthai',
                className: 'nk-tb-col',
                render: function(data) {
                    if (data === 'thanhcong') {
                        return `<span class="tb-odr-status">
                            <span class="badge badge-dot bg-success">Thành Công</span>
                        </span>`;
                    } else {
                        return `<span class="tb-odr-status">
                            <span class="badge badge-dot bg-danger">Thất Bại</span>
                        </span>`;
                    }
                }
            }
        ],
        language: {
            search: "",
            searchPlaceholder: "Tìm kiếm giao dịch...",
            lengthMenu: "Hiện&ensp;_MENU_&ensp;bản ghi",
            info: "Hiển thị _START_ đến _END_ của _TOTAL_ bản ghi",
            infoEmpty: "Hiển thị 0 đến 0 của 0 bản ghi",
            infoFiltered: "(được lọc từ _MAX_ bản ghi)",
            paginate: {
                first: "Tiếp theo",
                previous: "Trước đó",
                next: "Tiếp theo",
                last: "Trước đó"
            },
            loadingRecords: "Chưa có dữ liệu",
            processing: '<div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div>',
            emptyTable: "Không tìm thấy kết quả",
            zeroRecords: "Không tìm thấy kết quả"
        },
        pageLength: 10,
        ordering: true,
        order: [[5, 'desc']] 
    });

    let searchTimeout;
    $('.dataTables_filter input').off('keyup.DT input.DT');
    $('.dataTables_filter input').on('keyup', function() {
        clearTimeout(searchTimeout);
        const $this = $(this);
        searchTimeout = setTimeout(() => {
            $('.td-loader').show();
            dataTable.search($this.val()).draw();
        }, 400);
    });

    $('#bankTable').on('preXhr.dt', function(e, settings, data) {
        if (!$(document.activeElement).hasClass('dataTables_filter')) {
            $('.td-loader').show();
        }
    }).on('xhr.dt', function() {
        $('.td-loader').hide();
    });
});
</script>
<?php require_once('partials/foot.php'); ?>