<?php require_once('partials/head.php');?>
<?php require_once('partials/nav.php');?>
<div class="check-rotate-support"></div>
<div class="nk-content">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head">
                    <div class="nk-block-between g-3">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">Nhật Ký Hoạt Động</h3>
                            <div class="nk-block-des text-soft">
                                <p>Hệ thống có tổng cộng <?=$totals->Logs()?> bản ghi nhật ký hoạt động.</p>
                            </div>
                        </div>
                        <div class="nk-block-head-content">
                            <a class="btn btn-icon btn-danger d-md-none truncate-logs">
                                <em class="icon ni ni-trash-alt"></em>
                            </a>
                            <a class="btn btn-danger d-none d-md-inline-flex truncate-logs">
                                <i class="ri-delete-bin-2-line"></i>&ensp; <span>Xoá All Log</span>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="nk-block">
                    <div class="card card-bordered card-stretch">
                        <div class="card-inner-group">
                            <div class="card-inner">
                                <div class="card-title-group">
                                    <div class="card-title">
                                        <h5 class="title">Tất Cả Nhật Ký</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-inner table-responsive" style="margin-top:-30px;">
                            <table class="table table-tranx" id="logsTable">
                                <thead>
                                    <tr class="text-nowrap">
                                        <th scope="col">STT</th>
                                        <th scope="col">Tài Khoản</th>
                                        <th scope="col">Nhật Ký</th>
                                        <th scope="col">Thời Gian</th>
                                        <th scope="col">Hành Động</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', () => {
    if ($.fn.DataTable.isDataTable('#logsTable')) {
        $('#logsTable').DataTable().destroy();
    }
    const dataTable = $('#logsTable').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        ajax: {
            url: '/api/admin/handler?action=logList',
            type: 'GET',
            data: function(d) {
                return {
                    page: Math.floor(d.start / d.length) + 1,
                    limit: d.length,
                    search: d.search.value
                };
            },
            dataFilter: function(data) {
                let json = JSON.parse(data);
                json.recordsTotal = json.data.pagination.total_logs;
                json.recordsFiltered = json.data.pagination.total_logs;
                json.data = json.data.logs;
                return JSON.stringify(json);
            }
        },
        dom: '<"row justify-between g-2"<"col-7 col-sm-4 text-left"f><"col-5 col-sm-8 text-right"<"datatable-filter"<"d-flex justify-content-end g-2"l>>>><"datatable-wrap my-3"t><"row align-items-center"<"col-7 col-sm-12 col-md-9"p><"col-5 col-sm-12 col-md-3 text-end text-md-right"i>>',
        columns: [
            { 
                data: 'log_id',
                className: 'nk-tb-col'
            },
            { 
                data: null,
                className: 'nk-tb-col',
                render: function(data) {
                    const Username = window.THANHDIEU ? window.THANHDIEU(data.username) : data.username;
                    return `
                        <div class="user-card">
                        <div class="user-avatar" style="background-color:${data.avatar}">
                                <span>${Username.charAt(0).toUpperCase()}</span>
                            </div>
                            <div class="user-info">
                                <span class="tb-lead text-white">${Username}</span>
                                <span class="sub-text fs-12px">@${Username}</span>
                            </div>
                        </div>`;
                }
            },
            { 
                data: 'content',
                className: 'nk-tb-col',
            },
            { 
                data: 'time',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="text-muted">${window.FormatTime ? window.FormatTime.TD(data) : data}</span>`;
                }
            },
            { 
                data: 'action',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="badge rounded-pill bg-light">${data}</span>`;
                }
            }
        ],
        language: {
            search: "",
            searchPlaceholder: "Tìm kiếm nhật ký...",
            lengthMenu: "Hiện&ensp;_MENU_&ensp;bản ghi",
            info: "Hiển thị _START_ đến _END_ của _TOTAL_ bản ghi",
            infoEmpty: "Hiển thị 0 đến 0 của 0 bản ghi",
            infoFiltered: "(được lọc từ _MAX_ bản ghi)",
            paginate: {
                first: "Tiếp theo",
                previous: "Trước đó",
                next: "Tiếp theo",
                last: "Trước đó"
            },
            loadingRecords: "Chưa có dữ liệu",
            emptyTable: "Không tìm thấy kết quả",
            zeroRecords: "Không tìm thấy kết quả"
        },
        pageLength: 10,
        ordering: true,
        order: [[0, 'desc']]
    });
    let searchTimeout;
    $('.dataTables_filter input').off('keyup.DT input.DT');
    $('.dataTables_filter input').on('keyup', function() {
        clearTimeout(searchTimeout);
        const $this = $(this);
        searchTimeout = setTimeout(() => {
            $('.td-loader').show();
            dataTable.search($this.val()).draw();
        }, 400);
    });
    $('#logsTable').on('preXhr.dt', function(e, settings, data) {
        if (!$(document.activeElement).hasClass('dataTables_filter')) {
            $('.td-loader').show();
        }
    }).on('xhr.dt', function() {
        $('.td-loader').hide();
    });
    $('.truncate-logs').on('click', function() {
            dataTable.ajax.reload();
    });
});
</script>
<?php require_once('partials/foot.php'); ?>